#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cstdio>
#define ll long long int
using namespace std;


const ll mod = 1000000007;

ll BinPow(ll x, ll y)
{
	ll ans = 1;
	while (y > 0)
	{
		if (y % 2)
		{			
			ans = (ans * x) % mod;			
			--y;
		}
		else
		{
			x = (x * x) % mod;
			y /= 2;
		}
	}
	return ans;
}

ll Cnk(ll n, ll k)
{
	ll ans = 1;
	for (int i = 1; i <= n - k; ++i)
	{
		ans = ((ans * (n - i + 1)) * BinPow (i + 1, mod - 2)) % mod;
	}
	return ans;
}

long long F(int n, int D, int x)
{
	vector <vector <ll> > dp(n + 1, vector <ll> (n, 0));
	vector <ll> sum(n + 1);

	dp[0][0] = 1;
	sum[0] = 1;
	for (int i = 1; i <= n; ++i)
	{
		dp[i][0] = 0;
		sum[i] = sum[i - 1];
		if (i < x)
		{
			dp[i][0] = 1;
			sum[i] = sum[i - 1] + 1;
		}
	}
	for (int d = 1; d < n; ++d)
	{
		ll delta;
		for (int  i = 0; i <= n; ++i)
		{
			delta = 0;
			if (i >= x)
			{
				delta = sum[i - x];
			}
			dp[i][d] = (sum[i] - delta + mod) % mod;
		}
		sum[0] = dp[0][d];
		for (int i = 1; i <= n; ++i)
		{
			sum[i] = (sum[i - 1] + dp[i][d]) % mod;
		}
	}

	if (D <= n)
	{
		return dp[n][D - 1];
	}
	else
	{
		return (dp[n][n - 1] * Cnk(D, D - n)) % mod;
	}
}


int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);

	int n, d, x;
	cin >> n >> d >> x;

	/*cout << (6 / 3) % 5 << endl;
	cout << (6 * BinPow(3, 3)) % 5 << endl;
	cout <<BinPow(3, 3);*/
	
	while (n != 0)
	{
		cout << F(n, d, x) << endl;
		cin >> n >> d >> x;
	}


	return 0;
}